/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.AnimationType;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.IKeyframe;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.api.event.IAnimationEvent;
import lib.toma.animations.engine.frame.MutableKeyframe;
import lib.toma.animations.engine.screen.animator.AnimationProject;
import lib.toma.animations.engine.screen.animator.Animator;
import lib.toma.animations.engine.screen.animator.AnimatorFrameProvider;
import lib.toma.animations.engine.screen.animator.widget.WidgetContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class Timeline
extends WidgetContainer {
    private final Supplier<IKeyframeSelectContext> contextSupplier;
    private final AnimationProject project;
    private final int toolbarHeight = 20;
    private final int progressBarHeight = 10;
    private final int scrollbarWidth = 4;
    private final List<Display> displayList = new ArrayList<Display>();
    private int scrollIndex;
    private final int displaySize;
    private IKeyframeProvider backgroundProvider;
    private IProgressBarChange progressBarChange;
    private IKeyframeSelected keyframeSelected;
    private IEventClicked eventClicked;

    public Timeline(int x, int y, int width, int height, Supplier<IKeyframeSelectContext> contextSupplier) {
        super(x, y, width, height);
        this.project = Animator.get().getProject();
        this.displaySize = (height - 20 - 10) / 10;
        this.contextSupplier = contextSupplier;
        this.init();
    }

    public void init() {
        int i;
        int limit;
        for (Widget widget : this.displayList) {
            this.removeWidget(widget);
        }
        this.displayList.clear();
        int vertOffset = 30;
        boolean bl = this.project.hasEvents() && this.scrollIndex == 0;
        int defLimit = this.scrollIndex + this.displaySize;
        int n = limit = bl ? defLimit : defLimit - 1;
        if (bl) {
            IAnimationEvent[] events;
            Display display = new Display(0, vertOffset, this.field_230688_j_ - 4, 10, (ITextComponent)new StringTextComponent("Events"), this, this.contextSupplier);
            for (IAnimationEvent event : events = this.project.getFrameControl().getProvider().getEvents()) {
                display.addWidget(new Element<IAnimationEvent>(event, IAnimationEvent::invokeAt, display, ClickActionType.EVENT));
            }
            this.displayList.add(this.addWidget(display));
        }
        AnimatorFrameProvider provider = this.project.getFrameControl().getProvider();
        Map<AnimationStage, List<MutableKeyframe>> map = provider.getFrames();
        ArrayList<AnimationStage> stages = new ArrayList<AnimationStage>(map.keySet());
        int n2 = i = this.project.hasEvents() && this.scrollIndex == 1 ? this.scrollIndex - 1 : this.scrollIndex;
        while (i < limit && i < stages.size()) {
            AnimationStage stage = (AnimationStage)stages.get(i);
            List<MutableKeyframe> list = map.get(stage);
            if (list == null || list.isEmpty()) {
                provider.deleteStage(stage);
            } else {
                int j = i - this.scrollIndex + 1;
                Display display = new Display(0, vertOffset + j * 10, this.field_230688_j_ - 4, 10, stage.getName(), this, stage, this.contextSupplier);
                for (MutableKeyframe frame : list) {
                    display.addWidget(new Element<MutableKeyframe>(frame, IKeyframe::endpoint, display, ClickActionType.FRAME));
                }
                this.displayList.add(this.addWidget(display));
            }
            ++i;
        }
    }

    public AnimationProject getProject() {
        return this.project;
    }

    public void setProgressBarClickHandler(IProgressBarChange handler) {
        this.progressBarChange = handler;
    }

    public void setKeyframeSelectHandler(IKeyframeSelected handler) {
        this.keyframeSelected = handler;
    }

    public void setEventClickHandler(IEventClicked handler) {
        this.eventClicked = handler;
    }

    @Override
    public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        Timeline.func_238467_a_((MatrixStack)stack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)0x67000000);
        Timeline.func_238467_a_((MatrixStack)stack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + 20), (int)0x44000000);
        this.renderChildren(stack, mouseX, mouseY, partialTicks);
        this.renderProgressBar(stack);
        this.renderScrollbar(stack);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)this.field_230690_l_ && mouseX <= (double)(this.field_230690_l_ + this.field_230688_j_ - 4) && mouseY >= (double)(this.field_230691_m_ + 20) && mouseY <= (double)(this.field_230691_m_ + 20 + 10) && this.func_230987_a_(button)) {
            this.func_230982_a_(mouseX, mouseY);
            this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void func_230982_a_(double mx, double my) {
        if (this.progressBarChange != null) {
            float value = Math.max(0.0f, Math.min(1.0f, (float)(mx / (double)((float)this.field_230690_l_ + (float)this.field_230688_j_))));
            this.progressBarChange.onChanged(value);
        }
    }

    @Override
    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (!super.func_231043_a_(mouseX, mouseY, amount) && amount != 0.0 && this.func_231047_b_(mouseX, mouseY)) {
            this.onScrolled((int)amount);
            return true;
        }
        return false;
    }

    public void onScrolled(int amount) {
        int i = -amount;
        int j = this.scrollIndex + i;
        AnimatorFrameProvider provider = this.project.getFrameControl().getProvider();
        int elements = provider.getFrames().keySet().size();
        if (this.project.hasEvents()) {
            ++elements;
        }
        if (j >= 0 && j <= elements - this.displaySize) {
            this.scrollIndex = j;
            this.init();
        }
    }

    public void recompile(AnimationStage stage) {
        this.project.getFrameControl().getProvider().recompile(stage);
        this.init();
    }

    public void add(IAnimationEvent event) {
        this.project.getFrameControl().getProvider().addEvent(event);
        this.init();
    }

    public void replace(IAnimationEvent oldEvent, IAnimationEvent replacement) {
        AnimatorFrameProvider provider = this.project.getFrameControl().getProvider();
        provider.removeEvent(oldEvent);
        if (replacement != null) {
            provider.addEvent(replacement);
        }
        this.init();
    }

    public void add(AnimationStage stage, MutableKeyframe frame) {
        this.project.getFrameControl().getProvider().addFrame(stage, frame);
    }

    public void remove(AnimationStage stage, MutableKeyframe frame) {
        this.project.getFrameControl().getProvider().removeFrame(stage, frame);
        this.clearSelection();
    }

    public Animator.CustomizableAnimation getAnimation() {
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        Animator.CustomizableAnimation animation = pipeline.get(Animator.ANIMATOR_TYPE);
        if (animation == null) {
            animation = Animator.ANIMATOR_TYPE.create((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
            pipeline.insert(Animator.ANIMATOR_TYPE, animation);
        }
        return animation;
    }

    public void playAnimation() {
        AnimationType<Animator.CustomizableAnimation> type;
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        if (pipeline.get(type = Animator.ANIMATOR_TYPE) == null) {
            pipeline.insert(type);
        }
        if (pipeline.get(Animator.BACKGROUND_TYPE) == null) {
            this.playBackgroundAnimation();
        }
    }

    public float getAnimationProgress() {
        Animator.CustomizableAnimation animation = AnimationEngine.get().pipeline().get(Animator.ANIMATOR_TYPE);
        return animation != null ? animation.getProgress() : 0.0f;
    }

    public void setBackgroundAnimation(IKeyframeProvider provider) {
        this.backgroundProvider = provider;
        this.playBackgroundAnimation();
    }

    public void clearBackgroundAnimation() {
        this.backgroundProvider = null;
        this.playBackgroundAnimation();
    }

    protected boolean func_230987_a_(int p_230987_1_) {
        return p_230987_1_ == 0;
    }

    private void renderProgressBar(MatrixStack stack) {
        float progress = this.getAnimationProgress();
        int pos = this.field_230690_l_ + (int)(progress * (float)(this.field_230688_j_ - 4 - 5)) + 5;
        this.func_238473_b_(stack, pos, this.field_230691_m_ + 20, this.field_230691_m_ + this.field_230689_k_, -1);
        Timeline.func_238467_a_((MatrixStack)stack, (int)(pos - 2), (int)(this.field_230691_m_ + 20), (int)(pos + 3), (int)(this.field_230691_m_ + 20 + 10), (int)-1);
    }

    private void renderScrollbar(MatrixStack stack) {
        int left = this.field_230690_l_ + this.field_230688_j_ - 2;
        int right = left + 2;
        int top = this.field_230691_m_ + 20 + 10;
        int bottom = this.field_230691_m_ + this.field_230689_k_;
        Timeline.func_238467_a_((MatrixStack)stack, (int)left, (int)top, (int)right, (int)bottom, (int)-16777216);
        AnimatorFrameProvider provider = this.project.getFrameControl().getProvider();
        int total = provider.getFrames().keySet().size();
        if (this.project.hasEvents()) {
            ++total;
        }
        double size = 1.0 / (double)total * (double)(this.field_230689_k_ - 20 - 10);
        int minY = (int)((double)this.scrollIndex * size);
        int bottomIndex = Math.min(this.displaySize, total);
        int maxY = minY + (int)Math.ceil(size * (double)bottomIndex);
        Timeline.func_238467_a_((MatrixStack)stack, (int)left, (int)(top + minY), (int)right, (int)(top + maxY), (int)-1);
    }

    private void rightClickEvent(IAnimationEvent event) {
        if (this.eventClicked != null) {
            this.eventClicked.clicked(event);
        }
    }

    private void clearSelection() {
        if (this.keyframeSelected != null) {
            this.keyframeSelected.onSelect(null);
        }
    }

    private void rightClickFrame(AnimationStage stage, MutableKeyframe iKeyframe) {
        if (this.keyframeSelected != null) {
            this.keyframeSelected.onSelect(iKeyframe != null ? IKeyframeSelectContext.of(iKeyframe, stage) : null);
        }
    }

    private void playBackgroundAnimation() {
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        if (this.backgroundProvider == null) {
            pipeline.remove(Animator.BACKGROUND_TYPE);
            return;
        }
        pipeline.insert(Animator.BACKGROUND_TYPE, new Animator.BackgroundAnimation(this.backgroundProvider));
    }

    static enum ClickActionType {
        EVENT,
        FRAME;

    }

    private static class Element<T>
    extends Widget {
        private final Supplier<IKeyframeSelectContext> contextSupplier;
        private final Display owner;
        private final ClickActionType clickActionType;
        private final T t;

        public Element(T t, Function<T, Float> progress, Display owner, ClickActionType clickActionType) {
            super(0, 0, 10, 10, StringTextComponent.field_240750_d_);
            this.t = t;
            this.owner = owner;
            this.clickActionType = clickActionType;
            this.contextSupplier = owner.contextSupplier;
            int dx = owner.field_230690_l_;
            int dy = owner.getTimeline().field_230691_m_;
            int dw = owner.func_230998_h_() - 5;
            float posPct = progress.apply(t).floatValue();
            this.field_230690_l_ = dx + (int)((float)dw * posPct);
            this.field_230691_m_ = dy;
        }

        public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
            int color = this.isSelected() ? 52224 : 52428;
            Element.func_238467_a_((MatrixStack)stack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)(color | 0x89000000));
            Element.func_238467_a_((MatrixStack)stack, (int)(this.field_230690_l_ + 2), (int)(this.field_230691_m_ + 2), (int)(this.field_230690_l_ + this.field_230688_j_ - 2), (int)(this.field_230691_m_ + this.field_230689_k_ - 2), (int)(color | 0xFF000000));
        }

        public void func_230982_a_(double p_230982_1_, double p_230982_3_) {
            if (this.isSelected()) {
                this.owner.selected(ClickActionType.FRAME, null);
            } else {
                this.owner.selected(this.clickActionType, this.t);
            }
        }

        protected boolean func_230987_a_(int p_230987_1_) {
            return p_230987_1_ == 1;
        }

        private boolean isSelected() {
            IKeyframeSelectContext context = this.contextSupplier.get();
            return context != null && this.clickActionType == ClickActionType.FRAME && this.t == context.frame();
        }
    }

    private static class Display
    extends WidgetContainer {
        private final Supplier<IKeyframeSelectContext> contextSupplier;
        private final AnimationStage stage;
        private final Timeline owner;

        Display(int x, int y, int width, int height, ITextComponent title, Timeline owner, Supplier<IKeyframeSelectContext> contextSupplier) {
            this(x, y, width, height, title, owner, null, contextSupplier);
        }

        Display(int x, int y, int width, int height, ITextComponent title, Timeline owner, AnimationStage stage, Supplier<IKeyframeSelectContext> contextSupplier) {
            super(x, y, width, height);
            this.func_238482_a_(title);
            this.stage = stage;
            this.owner = owner;
            this.contextSupplier = contextSupplier;
        }

        @Override
        public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
            ITextComponent title = this.func_230458_i_();
            this.func_238465_a_(stack, this.field_230690_l_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + 5, -65536);
            Minecraft.func_71410_x().field_71466_p.func_243246_a(stack, title, (float)(this.field_230690_l_ + 2), (float)(this.field_230691_m_ + 1), 0xFFFFFF);
            this.renderChildren(stack, mouseX, mouseY, partialTicks);
        }

        public Timeline getTimeline() {
            return this.owner;
        }

        private void selected(ClickActionType type, Object value) {
            switch (type) {
                case EVENT: {
                    this.owner.rightClickEvent((IAnimationEvent)value);
                    break;
                }
                case FRAME: {
                    this.owner.rightClickFrame(this.stage, (MutableKeyframe)value);
                }
            }
        }
    }

    public static interface IKeyframeSelectContext
    extends Comparable<IKeyframeSelectContext> {
        public MutableKeyframe frame();

        public AnimationStage owner();

        public static IKeyframeSelectContext of(final MutableKeyframe frame, final AnimationStage owner) {
            return new IKeyframeSelectContext(){

                @Override
                public MutableKeyframe frame() {
                    return frame;
                }

                @Override
                public AnimationStage owner() {
                    return owner;
                }
            };
        }

        @Override
        default public int compareTo(IKeyframeSelectContext o) {
            return Float.compare(this.frame().endpoint(), o.frame().endpoint());
        }
    }

    public static interface IEventClicked {
        public void clicked(IAnimationEvent var1);
    }

    @FunctionalInterface
    public static interface IKeyframeSelected {
        public void onSelect(IKeyframeSelectContext var1);
    }

    @FunctionalInterface
    public static interface IProgressBarChange {
        public void onChanged(float var1);
    }
}

